# ✈️ Amerigo Voyage Flight Search API via URL

This documentation explains how to construct **valid flight search URLs** using the parameters supported by the Amerigo Voyage booking system. It supports:
- **Oneway**
- **Roundtrip**
- **Multicity (Multitrip)** searches.



## 🧩 Base URL
All searches use this base:
```
https://amerigovoyageinc.mywingsbooking.com/en/Flight/Search/Results
```

---

## 📦 Parameter Structure

### 🔢 `searchfor[n]`

This is the **core block** for defining **flight legs**:
- `n` is the **index of the flight leg** (starts at 0).
- Used in all trip types, but only **multicity** has more than one index.

Each `searchfor[n]` block includes:
| Parameter | Required? | Description |
|----------|-----------|-------------|
| `origin` | ✅ Yes | Origin airport IATA code (e.g. `DEL`) |
| `destination` | ✅ Yes | Destination airport IATA code (e.g. `BOM`) |
| `from` | ✅ Yes | Departure date (format: `dd.mm.yyyy`) |
| `to` | ❌ Only in roundtrip | Return date (format: `dd.mm.yyyy`) — required only when `triptype=roundtrip` |

---

## 🎟️ Common Passenger & Class Parameters

| Parameter | Required? | Description |
|----------|-----------|-------------|
| `passengers[adult]` | ✅ Yes | Number of adults |
| `passengers[children]` | ✅ Yes | Number of children (use `0` if none) |
| `passengers[infant]` | ✅ Yes | Number of infants (use `0` if none) |
| `class` | ✅ Yes | Travel class — e.g., `Economy`, `Business`, etc. |

---

## 🔁 Trip Type Breakdown

### 🟩 1. **Oneway Trip**

#### 📘 Description:
- Only **1 leg** of travel.
- Index `searchfor[0]` is used.
- No return date.

#### ✅ Required Parameters:
- `triptype=oneway`
- `searchfor[0][origin]`
- `searchfor[0][destination]`
- `searchfor[0][from]`
- Passenger and class parameters

#### 📎 Example:
```
https://amerigovoyageinc.mywingsbooking.com/en/Flight/Search/Results?triptype=oneway
&searchfor[0][origin]=DEL
&searchfor[0][destination]=BOM
&searchfor[0][from]=06.04.2025
&passengers[adult]=1
&passengers[children]=0
&passengers[infant]=0
&class=Economy
```

---

### 🟦 2. **Roundtrip**

#### 📘 Description:
- Two-way travel: outbound + return.
- Still uses **index 0** only.
- Requires an extra field: `searchfor[0][to]` (return date).

#### ✅ Required Parameters:
- `triptype=roundtrip`
- `searchfor[0][origin]`
- `searchfor[0][destination]`
- `searchfor[0][from]` (departure)
- `searchfor[0][to]` (return)
- Passenger and class parameters

#### 📎 Example:
```
https://amerigovoyageinc.mywingsbooking.com/en/Flight/Search/Results?triptype=roundtrip
&searchfor[0][origin]=DEL
&searchfor[0][destination]=BOM
&searchfor[0][from]=06.04.2025
&searchfor[0][to]=10.04.2025
&passengers[adult]=1
&passengers[children]=0
&passengers[infant]=0
&class=Economy
```

---

### 🟨 3. **Multicity (Multitrip)**

#### 📘 Description:
- Multiple separate flight legs.
- Each leg uses a new index: `searchfor[0]`, `searchfor[1]`, `searchfor[2]`, etc.
- No return (`to`) dates — only one `from` per leg.
- Each leg must include `origin`, `destination`, and `from`.

#### ✅ Required Parameters:
- `triptype=multicity`
- At least **2 blocks** like:
  - `searchfor[0][origin]`, `searchfor[0][destination]`, `searchfor[0][from]`
  - `searchfor[1][origin]`, `searchfor[1][destination]`, `searchfor[1][from]`
- Passenger and class parameters

#### 📎 Example:
**Leg 1:** DEL → BOM on 06.04.2025  
**Leg 2:** BOM → CCU on 18.04.2025
```
https://amerigovoyageinc.mywingsbooking.com/en/Flight/Search/Results?triptype=multicity
&searchfor[0][origin]=DEL
&searchfor[0][destination]=BOM
&searchfor[0][from]=06.04.2025
&searchfor[1][origin]=BOM
&searchfor[1][destination]=CCU
&searchfor[1][from]=18.04.2025
&passengers[adult]=1
&passengers[children]=0
&passengers[infant]=0
&class=Economy
```

---

## ✅ Summary

| Trip Type | Uses Index? | Needs `to` Date? | Example |
|-----------|-------------|------------------|---------|
| **Oneway** | `searchfor[0]` | ❌ No | ✅ |
| **Roundtrip** | `searchfor[0]` | ✅ Yes | ✅ |
| **Multicity** | `searchfor[0]`, `[1]`, `[2]`... | ❌ No | ✅ |

---