<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Log;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleController extends Controller
{
    public function index(Request $request)
    {
        Gate::authorize('view', Role::class);
        if($request->ajax()) {
            $roles = Role::withCount(['users'])->with(['permissions'])->get();
            return response()->json($roles);
        }
        return view('roles');
    }

    public function create()
    {
    }

    public function store(Request $request)
    {
        Gate::authorize('create', Role::class);
        try {
            DB::beginTransaction();
            $role = Role::create(['name' => $request->name]);
            $role->syncPermissions($request->permissions);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json($th, 500);
        } catch (\Throwable $e) {
            return response()->json($e, 400);
        }
        return response()->json($role->load('permissions')->loadCount(['users']));
    }

    public function show($id)
    {
    }

    public function edit($id)
    {
    }

    public function update(Request $request, $id)
    {
        Gate::authorize('edit', Role::class);
        try {
            DB::beginTransaction();
            $role = Role::findById($id);
            $role->name = $request->name;
            $role->save();
            $role->syncPermissions($request->permissions);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            Log::error($th->getMessage());
            return response()->json($th, 500);
        } catch (\Throwable $e) {
            Log::error($e->getMessage());
            return response()->json($e, 400);
        }
        return response()->json($role->load('permissions')->loadCount(['users']));
    }

    public function destroy($id)
    {
        Gate::authorize('delete', Role::class);
        try {
            DB::beginTransaction();
            $role = Role::findById($id);
            $role->delete();
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json($th, 500);
        } catch (\Throwable $e) {
            return response()->json($e, 400);
        }
        return response()->json('Role deleted successfully');
    }

    public function permissions()
    {
        $permissions = Permission::all();
        return response()->json($permissions);
    }
}
