<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CustomData extends Model
{
    protected $fillable = [
        'user_id',
        'date',
        'country',
        'customer_name',
        'daily_status',
        'comments',
        'time_date',
        'email',
        'number',
        'call_type',
        'company',
        'last_amount',
        'bttr',
        'payment_date',
        'final_status',
        'status',
        'agent_name'
    ];

    public function user(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
