<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class UserPolicy
{
    use HandlesAuthorization;

    public function view(User $user): bool
    {
        return $user->can('users.view');
    }

    public function create(User $user): bool
    {
        return $user->can('users.create');
    }

    public function edit(User $user): bool
    {
        return $user->can('users.edit');
    }

    public function delete(User $user): bool
    {
        return $user->can('users.delete');
    }
}
