<?php

namespace App\Providers;

use App\Models\CustomData;
use App\Models\User;
use App\Policies\CustomDataPolicy;
use App\Policies\RolePolicy;
use App\Policies\UserPolicy;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;
use Spatie\Permission\Models\Role;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Gate::before(fn($user, $ability) => $user->hasRole('super_admin') ? true : null);
        Gate::policy(Role::class, RolePolicy::class);
//        Gate::policy(User::class, UserPolicy::class);
        Gate::policy(CustomData::class, CustomDataPolicy::class);
    }
}
