<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('custom_data', function (Blueprint $table) {
            $table->id();
            $table->string('date')->nullable();
            $table->string('country', 100)->nullable();
            $table->string('customer_name', 150)->nullable();
            $table->string('daily_status', 255)->nullable();
            $table->text('comments')->nullable();
            $table->string('time_date')->nullable();
            $table->string('email', 150)->nullable();
            $table->string('number', 50)->nullable();
            $table->string('call_type', 100)->nullable();
            $table->string('company', 150)->nullable();
            $table->string('last_amount', 12, 2)->nullable();
            $table->string('bttr', 100)->nullable();
            $table->string('payment_date')->nullable();
            $table->string('final_status', 255)->nullable();
            $table->string('agent_name', 150)->nullable();
            $table->string('status', 100)->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('custom_data');
    }
};
