<?php

namespace Database\Seeders;

use App\Models\CustomData;
use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CustomDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $statuses = ['Sale Done', 'Denied', 'Call Back', 'Pitched', 'Conversation', 'Voicemail Left', 'Customer Services', 'Hung Up', 'Not Available', 'Voicemail', 'Not In Service'];
        $countries = ['India', 'USA', 'UK', 'Canada', 'Australia'];
        $callTypes = ['Follow-up', 'Inquiry', 'Cold Call', 'Support', 'Sales'];
        $agents = ['Kanhaiya', 'Ravi', 'Priya', 'Amit', 'Sneha'];

        for ($i = 1; $i <= 50; $i++) {
            CustomData::create([
                'date' => Carbon::now()->subDays(rand(0, 30))->format('Y-m-d'),
                'country' => $countries[array_rand($countries)],
                'customer_name' => 'Customer ' . $i,
                'daily_status' => $statuses[array_rand($statuses)],
                'comments' => 'Sample comment for customer ' . $i,
                'time_date' => Carbon::now()->subHours(rand(1, 48)),
                'email' => 'customer' . $i . '@example.com',
                'number' => '98765432' . str_pad($i, 2, '0', STR_PAD_LEFT),
                'call_type' => $callTypes[array_rand($callTypes)],
                'company' => 'Company ' . chr(65 + ($i % 26)),
                'last_amount' => rand(100, 5000),
                'bttr' => rand(0, 1) ? 'Yes' : 'No',
                'payment_date' => Carbon::now()->addDays(rand(1, 30))->format('Y-m-d'),
                'final_status' => $statuses[array_rand($statuses)],
                'status' => rand(0, 1) ? 'Active' : 'Inactive',
                'agent_name' => $agents[array_rand($agents)],
            ]);
        }
    }
}
