<?php

use App\Http\Controllers\CustomDataController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

Route::middleware(['guest.admin'])->group(function () {
    Route::get('/', [LoginController::class, 'login'])->name('login');
    Route::post('admin/authenticate', [LoginController::class, 'authenticate'])->name('admin.authenticate');
});
Route::middleware(['auth.admin'])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    Route::post('/logout', function () {
        Auth::logout();
        return redirect('/');
    })->name('admin.logout');

    Route::resource('users', UserController::class);
    Route::resource('roles', RoleController::class);
    Route::get('permissions', [RoleController::class, 'permissions'])->name('permissions');
});


Route::middleware(['auth.admin'])->prefix('custom-data')->group(function () {
    Route::get('/', [CustomDataController::class, 'index']);
    Route::post('/', [CustomDataController::class, 'store']);
    Route::get('/{id}', [CustomDataController::class, 'show']);
    Route::put('/{id}', [CustomDataController::class, 'update']);
    Route::delete('/{id}', [CustomDataController::class, 'destroy']);
    Route::get('/export/csv', [CustomDataController::class, 'export']);
    Route::post('/import', [CustomDataController::class, 'import']);
    Route::get('/permissions', [CustomDataController::class, 'checkPermissions']);
});
