
<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/users.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center">
                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Total Users</p>
                    <p class="text-2xl font-semibold text-gray-900" id="total-users">0</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-purple-500 rounded-full flex items-center justify-center">
                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Admin Users</p>
                    <p class="text-2xl font-semibold text-gray-900" id="admin-users">0</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Search and Filters -->
    <div class="bg-white rounded-lg shadow-sm border border-gray-200 mb-6 p-4">
        <div class="flex flex-col md:flex-row gap-4">
            <div class="search-container">
                <div class="search-icon">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                </div>
                <input type="text" id="search-input" class="search-input" placeholder="Search users by name, email, or role...">
            </div>

            <div class="flex gap-3">
                <select id="role-filter" class="form-input w-32">
                    <option value="">All Roles</option>
                </select>
            </div>
        </div>
    </div>

    <!-- Users Table -->
    <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
        <div class="overflow-auto">
            <table class="w-full border-collapse">
                <thead class="bg-gradient-to-r from-gray-50 to-gray-100 border-b-2 border-gray-200">
                <tr>
                    <th class="p-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider border-r">Avatar</th>
                    <th class="p-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider border-r">Name</th>
                    <th class="p-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider border-r">Email</th>
                    <th class="p-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider border-r">Role</th>
                    <th class="p-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider border-r">Created At</th>
                    <th class="p-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Actions</th>
                </tr>
                </thead>
                <tbody id="users-table-body" class="<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.edit')): ?> editable <?php endif; ?> <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.delete')): ?> deletable <?php endif; ?> <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('data.import')): ?> importable <?php endif; ?> <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('data.export')): ?> exportable <?php endif; ?>">
                <!-- Users will be populated here -->
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="mt-6 bg-white rounded-lg shadow-sm border border-gray-200 p-4">
        <div class="flex items-center justify-between">
            <div class="text-sm text-gray-600">
                Showing <span id="showing-from">1</span> to <span id="showing-to">10</span> of <span id="total-records">0</span> results
            </div>
            <div class="flex space-x-2">
                <button id="prev-page" class="px-3 py-1 text-sm bg-gray-200 rounded hover:bg-gray-300 disabled:opacity-50" disabled>Previous</button>
                <span id="current-page" class="px-3 py-1 text-sm bg-blue-500 text-white rounded">1</span>
                <button id="next-page" class="px-3 py-1 text-sm bg-gray-200 rounded hover:bg-gray-300 disabled:opacity-50" disabled>Next</button>
            </div>
        </div>
    </div>



    <!-- User Modal -->
    <div id="user-modal" class="modal-overlay">
        <div class="modal-content">
            <div class="p-6 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <h2 id="modal-title" class="text-xl font-semibold text-gray-900">Add New User</h2>
                    <button id="close-modal" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            </div>

            <form id="user-form" class="p-6">
                <div class="form-group">
                    <label class="form-label" for="name">First Name *</label>
                    <input type="text" id="name" name="name" class="form-input" required>
                </div>

                <div class="form-group">
                    <label class="form-label" for="email">Email Address *</label>
                    <input type="email" id="email" name="email" class="form-input" required>
                </div>

                <div class="form-group">
                    <label class="form-label" for="role">Role *</label>
                    <select id="role" name="role" class="form-input" required>
                        <option value="">Select Role</option>
                        <option value="admin">Admin</option>
                        <option value="manager">Manager</option>
                        <option value="agent">Agent</option>
                        <option value="user">User</option>
                    </select>
                </div>

                <div id="password-section">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="form-group">
                            <label class="form-label" for="password">Password *</label>
                            <input type="password" id="password" name="password" class="form-input">
                        </div>

                        <div class="form-group">
                            <label class="form-label" for="password-confirmation">Confirm Password *</label>
                            <input type="password" id="password-confirmation" name="password_confirmation" class="form-input">
                        </div>
                    </div>
                </div>

                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button" id="cancel-btn" class="px-4 py-2 text-gray-700 bg-gray-200 rounded-lg hover:bg-gray-300 transition-colors">
                        Cancel
                    </button>
                    <button type="submit" id="submit-btn" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                        Create User
                    </button>
                </div>
            </form>
        </div>
    </div>

    <input type="hidden" id="user-input" value="">
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/users.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home3/seonlineopi/tech.showcaseonline.xyz/resources/views/users.blade.php ENDPATH**/ ?>